package ru.yandex.solomon.gateway.api.old.grafana;

import java.util.List;
import java.util.stream.Collectors;

import com.google.common.base.MoreObjects;

import ru.yandex.solomon.expression.analytics.GraphDataLoadRequest;

/**
 * @author Vladimir Gordiychuk
 */
final class ResolvedMetrics {
    private final GraphDataLoadRequest request;
    private final List<Metric> metrics;

    ResolvedMetrics(GraphDataLoadRequest request, List<Metric> metrics) {
        this.request = request;
        this.metrics = metrics;
    }

    public GraphDataLoadRequest getRequest() {
        return request;
    }

    public List<Metric> getMetrics() {
        return metrics;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("metrics", metrics.stream()
                        .map(Metric::toString)
                        .collect(Collectors.joining("; ")))
                .toString();
    }
}
