package ru.yandex.solomon.gateway.api.old.grafana;

import java.time.Instant;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.util.collection.Nullables;
import ru.yandex.solomon.util.time.Interval;

/**
 * @author Vladimir Gordiychuk
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNonnullByDefault
public class SearchRequest {
    @Nullable
    @JsonProperty("panelId")
    private String panelId;
    @Nullable
    @JsonProperty(value = "dashboardId")
    private String dashboardId;
    @JsonProperty("intervalMs")
    private long intervalMillis;
    @JsonProperty("maxDataPoints")
    private long maxDataPoints;
    @JsonProperty("range")
    private Range range;
    @JsonProperty("targets")
    private List<Target> targets;

    public Interval getInterval() {
        return new Interval(Instant.parse(range.from), Instant.parse(range.to));
    }

    public long getGlobalGridMillis() {
        return intervalMillis;
    }

    public List<Target> getTargets() {
        return targets;
    }

    public String getDashboardIdOrAbsent() {
        return Nullables.orDefault(dashboardId, "absent");
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Range {
        @JsonProperty("from")
        private String from;
        @JsonProperty("to")
        private String to;

        @Override
        public String toString() {
            return "Range{" +
                "from='" + from + '\'' +
                ", to='" + to + '\'' +
                '}';
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Target {
        @JsonProperty("target")
        private String expression;
        @JsonProperty("refId")
        private String refId;

        public String getExpression() {
            return expression;
        }

        public String getRefId() {
            return refId;
        }

        @Override
        public String toString() {
            return "Target{" +
                "expression='" + expression + '\'' +
                ", refId='" + refId + '\'' +
                '}';
        }
    }

    @Override
    public String toString() {
        return "SearchRequest{" +
            "panelId='" + panelId + '\'' +
            ", intervalMillis=" + intervalMillis +
            ", maxDataPoints=" + maxDataPoints +
            ", targets=" + targets +
            '}';
    }
}
