package ru.yandex.solomon.gateway.api.old.grafana;

import java.io.IOException;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;

/**
 * @author Vladimir Gordiychuk
 */
public class WwwTimeSeries {
    @JsonProperty("target")
    String target;
    @JsonProperty("datapoints")
    List<WwwPoint> points;

    public WwwTimeSeries(String target, List<WwwPoint> points) {
        this.target = target;
        this.points = points;
    }

    public String getTarget() {
        return target;
    }

    public List<WwwPoint> getPoints() {
        return points;
    }

    public static class WwwPoint implements JsonSerializable {
        private final long tsMillis;
        private final double value;

        public WwwPoint(long tsMillis, double value) {
            this.tsMillis = tsMillis;
            this.value = value;
        }

        public long getTsMillis() {
            return tsMillis;
        }

        public double getValue() {
            return value;
        }

        @Override
        public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartArray();
            if (Double.isNaN(value)) {
                jgen.writeNull();
            } else {
                jgen.writeNumber(value);
            }
            jgen.writeNumber(tsMillis);
            jgen.writeEndArray();
        }

        @Override
        public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            throw new RuntimeException("unreachable");
        }
    }
}
