package ru.yandex.solomon.gateway.api.old.grafana;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;

import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.expression.value.SelValueGraphData;
import ru.yandex.solomon.expression.value.SelValueVector;
import ru.yandex.solomon.labels.FormatLabel;

import static java.util.stream.Collectors.toList;

/**
 * @author Vladimir Gordiychuk
 */
public class WwwTimeSeriesConverter {
    static List<WwwTimeSeries> toTimeSeries(SelValue selValue, String defaultName) {
        if (selValue.type().isGraphData()) {
            WwwTimeSeries timeSeries = createTimeSeries(selValue.castToGraphData().getNamedGraphData(), Collections.emptySet(), defaultName);
            return Collections.singletonList(timeSeries);
        } else if (selValue.type().isVector()) {
            var uniqueLabels = uniqueLabels(selValue.castToVector());
            return Stream.of(selValue.castToVector().valueArray())
                    .map(SelValue::castToGraphData)
                    .map(SelValueGraphData::getNamedGraphData)
                    .map(namedGraphData -> createTimeSeries(namedGraphData, uniqueLabels, defaultName))
                    .collect(toList());
        }

        return Collections.emptyList();
    }

    private static Set<String> uniqueLabels(SelValueVector vector) {
        if (vector.length() <= 1) {
            return Collections.emptySet();
        }

        var values = vector.valueArray();
        Map<String, String> uniqueLabels = values[0].castToGraphData().getNamedGraphData().getLabels().toMap();
        for (int index = 1; index < values.length; index++) {
            var labels = values[index].castToGraphData().getNamedGraphData().getLabels();
            labels.forEach(label -> {
                if (Objects.equals(uniqueLabels.get(label.getKey()), label.getValue())) {
                    uniqueLabels.remove(label.getKey());
                }
            });
        }

        return uniqueLabels.keySet();
    }

    private static WwwTimeSeries createTimeSeries(NamedGraphData namedGraphData, Set<String> uniqueLabels, String defaultName) {
        String name = namedGraphData.getAlias();

        if (name.isEmpty()) {
            var labels = namedGraphData.getLabels();
            if (labels.isEmpty() || uniqueLabels.isEmpty()) {
                name = "";
            } else if (uniqueLabels.size() == 1) {
                String key = uniqueLabels.iterator().next();
                var label = labels.findByKey(key);
                if (label == null) {
                    name = "";
                } else {
                    name = label.getValue();
                }
            } else {
                String result = FormatLabel.format(labels.stream()
                        .filter(l -> uniqueLabels.contains(l.getKey())));
                name = Strings.isNullOrEmpty(result) ? "" : result;
            }
        }

        if (name.isEmpty()) {
            name = defaultName;
        }

        List<WwwTimeSeries.WwwPoint> points = Lists.newArrayList();
        namedGraphData.getGraphData()
                .visit((tsMillis, value) -> points.add(new WwwTimeSeries.WwwPoint(tsMillis, value)));

        return new WwwTimeSeries(name, points);
    }
}
