package ru.yandex.solomon.gateway.api.staffOnly;

import java.util.Optional;

import ru.yandex.cloud.auth.token.TokenProvider;
import ru.yandex.passport.tvmauth.TvmClient;
import ru.yandex.solomon.auth.AuthType;
import ru.yandex.solomon.config.protobuf.frontend.TStaffOnlyConfig;

/**
 * @author Sergey Polovko
 */
final class AuthProvider {
    private final Optional<TvmClient> tvmClient;
    private final Optional<TokenProvider> iamTokenProvider;

    public AuthProvider(Optional<TvmClient> tvmClient, Optional<TokenProvider> iamTokenProvider) {
        this.tvmClient = tvmClient;
        this.iamTokenProvider = iamTokenProvider;
    }

    AuthType authType(TStaffOnlyConfig.TServiceConfig serviceConfig) {
        if (serviceConfig.hasAuthTvm()) {
            return AuthType.TvmService;
        }
        if (serviceConfig.hasAuthIam()) {
            return AuthType.IAM;
        }
        return AuthType.Anonymous;
    }

    TokenProvider tokenProvider(TStaffOnlyConfig.TServiceConfig serviceConfig) {
        if (serviceConfig.hasAuthTvm()) {
            return () -> {
                int clientId = serviceConfig.getAuthTvm().getDstClientId();
                return tvmClient.orElseThrow().getServiceTicketFor(clientId);
            };
        }

        if (serviceConfig.hasAuthIam()) {
            return iamTokenProvider.orElseThrow();
        }

        return TokenProvider.of("");
    }
}
