package ru.yandex.solomon.gateway.api.v2;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.auth.Account;
import ru.yandex.solomon.labels.shard.ShardKey;

/**
 * @author Vladimir Gordiychuk
 */
// TODO: drop it after enable authorization on push SOLOMON-6147 (@gordiychuk)
public class AuthPushMetrics implements MetricSupplier {
    private final Cache<String, ServiceMetrics> serviceMetrics = CacheBuilder.newBuilder()
            .expireAfterAccess(10, TimeUnit.MINUTES)
            .build();

    @Override
    public int estimateCount() {
        return 0;
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        for (var metrics : serviceMetrics.asMap().values()) {
            metrics.append(tsMillis, commonLabels, consumer);
        }
    }

    private ServiceMetrics serviceMetrics(String name) {
        var metrics = serviceMetrics.getIfPresent(name);
        if (metrics == null) {
            metrics = new ServiceMetrics(name);
            serviceMetrics.put(name, metrics);
        }

        return metrics;
    }

    public void forFuture(ShardKey key, CompletableFuture<Account> future) {
        var metrics = serviceMetrics(key.getService());
        future.whenComplete((account, throwable) -> {
            if (throwable != null) {
                metrics.failed.inc();
            } else {
                metrics.success.inc();
            }
        });
    }

    private static class ServiceMetrics implements MetricSupplier {
        private final MetricRegistry registry;
        private final Rate success;
        private final Rate failed;

        public ServiceMetrics(String name) {
            this.registry = new MetricRegistry(Labels.of("serviceName", name));
            this.success = registry.rate("push.service.authorizeSuccess");
            this.failed = registry.rate("push.service.authorizeFailed");
        }

        @Override
        public int estimateCount() {
            return 0;
        }

        @Override
        public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
            registry.append(tsMillis, commonLabels, consumer);
        }
    }
}
