package ru.yandex.solomon.gateway.api.v2;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import io.swagger.annotations.Api;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.http.RequireAuth;
import ru.yandex.solomon.core.conf.ProjectsManager;
import ru.yandex.solomon.gateway.api.v2.dto.ProjectsListDto;

/**
 * @author Alexey Trushkin
 */
@Api(tags = "projects")
@RestController
@RequestMapping(produces = MediaType.APPLICATION_JSON_VALUE)
@ParametersAreNonnullByDefault
public class ProjectsListController {

    private final ProjectsManager projectsManager;

    public ProjectsListController(ProjectsManager projectsManager) {
        this.projectsManager = projectsManager;
    }

    @RequestMapping(path = "/api/v2/projectsList", method = RequestMethod.GET)
    CompletableFuture<ProjectsListDto> list(
            @RequireAuth AuthSubject subject,
            @RequestParam(value = "pageSize", defaultValue = "100") int pageSize,
            @RequestParam(value = "pageToken", defaultValue = "") String pageToken)
    {
        return projectsManager.listProjects(pageSize, pageToken)
                .thenApply(ProjectsListDto::from);
    }
}
