package ru.yandex.solomon.gateway.api.v2.dto;

import java.util.EnumSet;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import ru.yandex.solomon.core.db.model.ProjectPermission;


/**
 * @author rorewillo
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AclEntryDto {

    private String login;
    private EnumSet<ProjectPermission> permissions;

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public EnumSet<ProjectPermission> getPermissions() {
        return permissions;
    }

    public void setPermissions(EnumSet<ProjectPermission> permissions) {
        this.permissions = permissions;
    }

    public void validate() {
        ValidationUtils.validateLogin("acl login", login);
    }

    @Override
    public String toString() {
        return "AclEntryDto{" +
            "login='" + login + '\'' +
            ", permissions=" + permissions +
            '}';
    }
}
