package ru.yandex.solomon.gateway.api.v2.dto;

import java.time.Instant;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import ru.yandex.solomon.core.db.model.Cluster;
import ru.yandex.solomon.core.db.model.ShardSettings;

/**
 * @author Sergey Polovko
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ClusterListItemDto {

    private String id;
    private String name;
    private Integer hostGroupsCount;
    private Integer metricsTtl;
    private Instant createdAt;
    private Instant updatedAt;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getHostGroupsCount() {
        return hostGroupsCount;
    }

    public void setHostGroupsCount(Integer hostGroupsCount) {
        this.hostGroupsCount = hostGroupsCount;
    }

    public Integer getMetricsTtl() {
        return metricsTtl;
    }

    public void setMetricsTtl(Integer metricsTtl) {
        this.metricsTtl = metricsTtl;
    }

    public Instant getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public Instant getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Nonnull
    public static ClusterListItemDto fromModel(@Nonnull Cluster cluster) {
        ClusterListItemDto dto = new ClusterListItemDto();
        dto.setId(cluster.getId());
        dto.setName(cluster.getName());
        dto.hostGroupsCount = cluster.getHostGroupsCount();
        dto.metricsTtl = ShardSettings.getMetricsTtlDays(cluster.getShardSettings(), null);
        dto.setCreatedAt(cluster.getCreatedAt());
        dto.setUpdatedAt(cluster.getUpdatedAt());
        return dto;
    }
}
