package ru.yandex.solomon.gateway.api.v2.dto;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.core.db.model.ClusterServiceAssociation;
import ru.yandex.solomon.core.db.model.ShardState;

/**
 * @author Sergey Polovko
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ClusterServiceAssociationDto {

    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String shardId;
    @JsonProperty
    private int version;
    @JsonProperty
    private ShardState state;

    @Nonnull
    public static ClusterServiceAssociationDto fromModel(@Nonnull ClusterServiceAssociation association) {
        ClusterServiceAssociationDto dto = new ClusterServiceAssociationDto();
        dto.id = association.getId();
        dto.name = association.getName();
        dto.shardId = association.getShardId();
        dto.version = association.getShardVersion();
        dto.state = association.getShardState();
        return dto;
    }
}
