package ru.yandex.solomon.gateway.api.v2.dto;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.core.db.model.Dashboard;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DashboardListItemDto {

    @JsonProperty
    private String id;
    @JsonProperty
    private String name;

    @Nonnull
    public static DashboardListItemDto fromModel(@Nonnull Dashboard model) {
        DashboardListItemDto dto = new DashboardListItemDto();
        dto.id = model.getId();
        dto.name = model.getName();
        return dto;
    }
}
