package ru.yandex.solomon.gateway.api.v2.dto;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.core.db.model.DashboardPanel;
import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DashboardPanelDto {

    private static final int MAX_SPAN_VALUE = 30;

    @JsonProperty
    private DashboardPanel.Type type;
    @JsonProperty
    private String title;
    @JsonProperty
    private String subtitle;
    @JsonProperty
    private String url;
    @JsonProperty
    private String markdown;
    @JsonProperty
    private int rowspan;
    @JsonProperty
    private int colspan;

    public void validate() {
        if (rowspan < 0) {
            throw new BadRequestException("rowspan cannot be negative");
        }
        if (colspan < 0) {
            throw new BadRequestException("colspan cannot be negative");
        }
        if (rowspan > MAX_SPAN_VALUE) {
            throw new BadRequestException(String.format("rowspan cannot be greater than %d", MAX_SPAN_VALUE));
        }
        if (colspan > MAX_SPAN_VALUE) {
            throw new BadRequestException(String.format("colspan cannot be greater than %d", MAX_SPAN_VALUE));
        }
    }

    @Nonnull
    public DashboardPanel toModel() {
        return new DashboardPanel(type, title, subtitle, url, markdown, rowspan, colspan);
    }

    @Nonnull
    public static DashboardPanelDto fromModel(@Nonnull DashboardPanel panel) {
        DashboardPanelDto dto = new DashboardPanelDto();
        dto.type = panel.getType();
        dto.title = panel.getTitle();
        dto.subtitle = panel.getSubtitle();
        dto.url = panel.getUrl();
        dto.markdown = panel.getMarkdown();
        dto.rowspan = panel.getRowspan();
        dto.colspan = panel.getColspan();
        return dto;
    }
}
