package ru.yandex.solomon.gateway.api.v2.dto;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.monitoring.api.v3.ListDeleteMetricsOperationsResponse;

import static java.util.stream.Collectors.toList;

/**
 * @author Stanislav Kashirin
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNullableByDefault
public class DeleteMetricsOperationsListDto {

    @ApiModelProperty(
        value = "Found deletion operations.",
        required = true,
        position = 0)
    @JsonProperty
    public List<DeleteMetricsOperationDto> result;

    @ApiModelProperty(
        value = "Token to retrieve the next page of results, or empty if there are no more results in the list.",
        required = true,
        position = 1)
    @JsonProperty
    public String nextPageToken;

    @Nonnull
    public static DeleteMetricsOperationsListDto fromProto(@Nonnull ListDeleteMetricsOperationsResponse proto) {
        var dto = new DeleteMetricsOperationsListDto();
        dto.result = proto.getOperationsList().stream()
            .map(DeleteMetricsOperationDto::fromProto)
            .collect(toList());
        dto.nextPageToken = proto.getNextPageToken();
        return dto;
    }
}


