package ru.yandex.solomon.gateway.api.v2.dto;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Stanislav Kashirin
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNullableByDefault
public class DeleteMetricsRequestDto {

    @ApiModelProperty(
        value = "Text description attached to the operation (purpose of the deletion, links to issues in tracker, etc).",
        required = false,
        position = 1)
    @JsonProperty
    public String description;

    @ApiModelProperty(
        value = "Selectors used to resolve which metrics to delete.",
        required = true,
        position = 2)
    @JsonProperty
    public String selectors;

    public void validate() {
        if (StringUtils.isBlank(selectors)) {
            throw new BadRequestException("selectors cannot be blank");
        }
    }

}
