package ru.yandex.solomon.gateway.api.v2.dto;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.monitoring.api.v3.Operation;

/**
 * @author Stanislav Kashirin
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNullableByDefault
public class DeleteMetricsResponseDto {

    @ApiModelProperty(
        value = "Operation ID.",
        required = true,
        position = 0)
    @JsonProperty
    public String operationId;

    @Nonnull
    public static DeleteMetricsResponseDto fromProto(@Nonnull Operation proto) {
        var dto = new DeleteMetricsResponseDto();
        dto.operationId = proto.getId();
        return dto;
    }
}
