package ru.yandex.solomon.gateway.api.v2.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.core.conf.flags.FeatureFlagsPage;
import ru.yandex.solomon.flags.FeatureFlag;
import ru.yandex.solomon.flags.FeatureFlags;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class FeatureFlagDto {

    @ApiModelProperty(
            value = "flag name",
            readOnly = true,
            required = true)
    public String name;

    @ApiModelProperty(
            value = "flag description",
            readOnly = true,
            required = true)
    public String description;

    @ApiModelProperty(
            value = "flag id",
            readOnly = true,
            required = true)
    public String id;

    @ApiModelProperty(
            value = "flag state",
            readOnly = true,
            required = true)
    public FeatureFlagsPage.FlagState state;

    @ApiModelProperty(
            value = "where flag is defined",
            readOnly = true,
            required = true)
    public String definedIn;

    public static List<FeatureFlagDto> from(@Nonnull FeatureFlags flags,@Nonnull Function<FeatureFlag, String> definer) {
        List<FeatureFlagDto> result = new ArrayList<>();
        for (FeatureFlag value : FeatureFlag.values()) {
            FeatureFlagDto dto = new FeatureFlagDto();
            dto.name = value.getDisplayName();
            dto.description = value.getDescription();
            dto.id = value.name();
            dto.state = FeatureFlagsPage.getFlagState(value, flags);
            dto.definedIn = definer.apply(value);
            result.add(dto);
        }
        return result;
    }
}
