package ru.yandex.solomon.gateway.api.v2.dto;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.core.db.model.Cluster;
import ru.yandex.solomon.core.db.model.Dashboard;
import ru.yandex.solomon.core.db.model.Service;
import ru.yandex.solomon.core.db.model.graph.Graph;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GlobalEntityListItemDto {

    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String projectId;

    @Nonnull
    public static GlobalEntityListItemDto fromModel(@Nonnull Cluster model) {
        GlobalEntityListItemDto dto = new GlobalEntityListItemDto();
        dto.id = model.getId();
        dto.name = model.getName();
        dto.projectId = model.getProjectId();
        return dto;
    }

    @Nonnull
    public static GlobalEntityListItemDto fromModel(@Nonnull Service model) {
        GlobalEntityListItemDto dto = new GlobalEntityListItemDto();
        dto.id = model.getId();
        dto.name = model.getName();
        dto.projectId = model.getProjectId();
        return dto;
    }

    @Nonnull
    public static GlobalEntityListItemDto fromModel(@Nonnull Graph model) {
        GlobalEntityListItemDto dto = new GlobalEntityListItemDto();
        dto.id = model.getId();
        dto.name = model.getName();
        dto.projectId = model.getProjectId();
        return dto;
    }

    @Nonnull
    public static GlobalEntityListItemDto fromModel(@Nonnull Dashboard model) {
        GlobalEntityListItemDto dto = new GlobalEntityListItemDto();
        dto.id = model.getId();
        dto.name = model.getName();
        dto.projectId = model.getProjectId();
        return dto;
    }
}
