package ru.yandex.solomon.gateway.api.v2.dto;

import java.util.Arrays;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.solomon.core.db.model.graph.GraphElement;
import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GraphElementListDto {

    public static final GraphElement[] EMPTY_GRAPH_ELEMENTS = new GraphElement[0];
    private GraphElementDto[] elements;

    @JsonValue
    public GraphElementDto[] getElements() {
        return elements;
    }

    @JsonCreator
    public GraphElementListDto(GraphElementDto[] elements) {
        this.elements = elements;
    }

    public void validate() {
        if (elements != null) {
            for (GraphElementDto dto : elements) {
                if (dto == null) {
                    throw new BadRequestException("graph element must not be null");
                }
                dto.validate();
            }
        }
    }

    @Nonnull
    public static GraphElementListDto fromModel(@Nonnull GraphElement[] elements) {
        GraphElementDto[] dtos =
            Arrays.stream(elements)
                .map(GraphElementDto::fromModel)
                .toArray(GraphElementDto[]::new);
        return new GraphElementListDto(dtos);
    }

    @Nonnull
    public static GraphElement[] toModel(@Nullable GraphElementListDto dto) {
        if (dto == null) {
            return EMPTY_GRAPH_ELEMENTS;
        }
        GraphElementDto[] dtos = dto.getElements();
        if (dtos == null) {
            return EMPTY_GRAPH_ELEMENTS;
        }
        return Arrays.stream(dtos).map(GraphElementDto::toModel).toArray(GraphElement[]::new);
    }
}
