package ru.yandex.solomon.gateway.api.v2.dto;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.core.db.model.graph.Graph;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GraphListItemDto {

    @JsonProperty
    private String id;
    @JsonProperty
    private String name;

    public static GraphListItemDto fromModel(Graph model) {
        GraphListItemDto dto = new GraphListItemDto();
        dto.id = model.getId();
        dto.name = model.getName();
        return dto;
    }
}
