package ru.yandex.solomon.gateway.api.v2.dto;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.core.label.LabelConf;
import ru.yandex.solomon.metrics.client.LabelNamesResponse;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class LabelNamesResponseDto {

    @JsonProperty
    private List<String> names;

    @Nonnull
    public static LabelNamesResponseDto fromModel(@Nonnull LabelNamesResponse model) {
        LabelNamesResponseDto dto = new LabelNamesResponseDto();
        ArrayList<String> names = new ArrayList<>(model.getNames());
        names.sort(LabelConf.getPartialSorterComparator());
        dto.names = names;
        return dto;
    }
}
