package ru.yandex.solomon.gateway.api.v2.dto;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.util.labelStats.LabelStats;
import ru.yandex.solomon.util.text.TextWithNumbersComparator;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class LabelValuesDto {

    @JsonProperty
    private String name;
    @JsonProperty
    private List<String> values;
    @JsonProperty
    private boolean absent;
    @JsonProperty
    private boolean truncated;

    @Nonnull
    public static LabelValuesDto fromModel(
        @Nonnull String name,
        @Nonnull LabelStats labelStats,
        boolean absent)
    {
        List<String> sortedValues =
            labelStats.getValues().stream()
                .sorted(TextWithNumbersComparator.instance)
                .collect(Collectors.toList());

        LabelValuesDto dto = new LabelValuesDto();
        dto.name = name;
        dto.values = sortedValues;
        dto.absent = absent;
        dto.truncated = labelStats.isTruncated();
        return dto;
    }
}
