package ru.yandex.solomon.gateway.api.v2.dto;

import java.time.Instant;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.solomon.model.MetricKey;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MetricDto {

    @JsonProperty
    private String name;
    @JsonProperty
    private Map<String, String> labels;
    @JsonProperty
    private MetricType kind; // should be removed
    @JsonProperty
    private MetricType type;
    @JsonProperty
    private Instant createdAt;

    public static MetricDto fromModel(@Nonnull MetricKey model) {
        MetricDto dto = new MetricDto();
        if (!model.getName().isEmpty()) {
            dto.name = model.getName();
        }
        dto.labels = model.getLabels().toMap();
        dto.kind = model.getType();
        dto.type = model.getType();
        dto.createdAt = Instant.ofEpochMilli(model.getCreatedAtMillis());
        return dto;
    }
}
