package ru.yandex.solomon.gateway.api.v2.dto;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.metrics.client.MetricNamesResponse;
import ru.yandex.solomon.util.text.TextWithNumbersComparator;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MetricNamesResponseDto {

    @JsonProperty
    private List<String> names;
    @JsonProperty
    private boolean truncated;

    @Nonnull
    public static MetricNamesResponseDto fromModel(@Nonnull MetricNamesResponse model) {
        var dto = new MetricNamesResponseDto();

        dto.names = model.getNames()
            .stream()
            .sorted(TextWithNumbersComparator.instance)
            .collect(Collectors.toList());

        dto.truncated = model.isTruncated();

        return dto;
    }
}
