package ru.yandex.solomon.gateway.api.v2.dto;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import ru.yandex.solomon.ydb.page.PagedResult;

/**
 * @author Sergey Polovko
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PagedResultDto<T> {

    private List<T> result;
    private PageDto page;


    public List<T> getResult() {
        return result;
    }

    public void setResult(List<T> result) {
        this.result = result;
    }

    public PageDto getPage() {
        return page;
    }

    public void setPage(PageDto page) {
        this.page = page;
    }

    @Nonnull
    public static <Model, Dto> PagedResultDto<Dto> fromModel(
        @Nonnull PagedResult<Model> pagedResult,
        @Nonnull Function<Model, Dto> dtoMapper)
    {
        PagedResultDto<Dto> dto = new PagedResultDto<>();
        List<Dto> dtoResult = pagedResult.getResult().stream()
            .map(dtoMapper)
            .collect(Collectors.toList());
        dto.setResult(dtoResult);

        PageDto pageDto = new PageDto();
        pageDto.setPagesCount(pagedResult.getPagesCount());
        pageDto.setPageSize(pagedResult.getPageSize());
        pageDto.setCurrent(pagedResult.getCurrentPage());
        pageDto.setTotalCount(pagedResult.getTotalCount());

        dto.setPage(pageDto);
        return dto;
    }

    /**
     * PAGE
     */
    @ParametersAreNullableByDefault
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class PageDto {
        private int pagesCount;
        private int totalCount;
        private int pageSize;
        private int current;

        public int getPagesCount() {
            return pagesCount;
        }

        public void setPagesCount(int pagesCount) {
            this.pagesCount = pagesCount;
        }

        public int getTotalCount() {
            return totalCount;
        }

        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
        }

        public int getPageSize() {
            return pageSize;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        public int getCurrent() {
            return current;
        }

        public void setCurrent(int current) {
            this.current = current;
        }
    }
}
