package ru.yandex.solomon.gateway.api.v2.dto;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import ru.yandex.solomon.core.db.model.Project;

/**
 * @author Sergey Polovko
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProjectListItemDto {

    private String id;
    private String name;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nonnull
    public static ProjectListItemDto fromModel(@Nonnull Project project) {
        ProjectListItemDto dto = new ProjectListItemDto();
        dto.setId(project.getId());
        dto.setName(project.getName());
        return dto;
    }
}
