package ru.yandex.solomon.gateway.api.v2.dto;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import ru.yandex.solomon.core.db.model.Project;
import ru.yandex.solomon.ydb.page.TokenBasePage;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProjectsListDto {

    public String nextPageToken;
    public List<ProjectDto> projects;

    public static ProjectsListDto from(@Nonnull TokenBasePage<Project> tokenBasePage) {
        ProjectsListDto dto = new ProjectsListDto();
        dto.nextPageToken = tokenBasePage.getNextPageToken();
        dto.projects = tokenBasePage.getItems().stream()
                .map(ProjectDto::fromModel)
                .collect(Collectors.toList());
        return dto;
    }
}
