package ru.yandex.solomon.gateway.api.v2.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.monitoring.coremon.TDataProcessResponse;
import ru.yandex.solomon.proto.UrlStatusType;


/**
 * @author Sergey Polovko
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PushResultDto {

    @JsonProperty
    private UrlStatusType status;
    @JsonProperty("sensorsProcessed")
    private int metricsProcessed;
    @JsonProperty
    private String errorMessage;

    public static PushResultDto fromModel(TDataProcessResponse r) {
        PushResultDto dto = new PushResultDto();
        dto.status = r.getStatus();
        dto.metricsProcessed = r.getSuccessMetricCount();
        if (r.getStatus() != UrlStatusType.OK && StringUtils.isNotEmpty(r.getErrorMessage())) {
            dto.errorMessage = r.getErrorMessage();
        }
        return dto;
    }
}
