package ru.yandex.solomon.gateway.api.v2.dto;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.solomon.core.db.model.Selector;
import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SelectorDto {

    private String name;
    private String value;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void validate() {
        if (StringUtils.isBlank(name)) {
            throw new BadRequestException("selector name cannot be blank");
        }
        if (StringUtils.isBlank(value)) {
            throw new BadRequestException("selector value cannot be blank");
        }
    }

    @Nonnull
    public static SelectorDto fromModel(@Nonnull Selector selector) {
        SelectorDto dto = new SelectorDto();
        dto.setName(selector.getName());
        dto.setValue(selector.getValue());
        return dto;
    }

    @Nonnull
    public static SelectorDto fromModel(@Nonnull String name, @Nonnull String value) {
        SelectorDto dto = new SelectorDto();
        dto.setName(name);
        dto.setValue(value);
        return dto;
    }

    @Nonnull
    public static Selector toModel(@Nonnull SelectorDto dto) {
        return new Selector(
            dto.name,
            dto.value
        );
    }
}
