package ru.yandex.solomon.gateway.api.v2.dto;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.solomon.core.db.model.Selector;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SelectorListDto {

    private List<SelectorDto> selectors;

    @JsonValue
    public List<SelectorDto> getSelectors() {
        return selectors;
    }

    @JsonCreator
    public SelectorListDto(List<SelectorDto> selectors) {
        this.selectors = selectors;
    }

    public void validate() {
        if (selectors != null) {
            for (SelectorDto selectorDto : selectors) {
                selectorDto.validate();
            }
        }
    }

    @Nonnull
    public static SelectorListDto fromModel(@Nonnull Selector[] selectors) {
        List<SelectorDto> selectorDtos =
            Arrays.stream(selectors)
                .map(SelectorDto::fromModel)
                .collect(Collectors.toList());
        return new SelectorListDto(selectorDtos);
    }

    @Nonnull
    public static Selector[] toModel(@Nullable SelectorListDto dto) {
        if (dto == null) {
            return new Selector[0];
        }
        List<SelectorDto> selectors = dto.getSelectors();
        if (selectors == null) {
            return new Selector[0];
        }
        return selectors.stream().map(SelectorDto::toModel).toArray(Selector[]::new);
    }
}
