package ru.yandex.solomon.gateway.api.v2.dto;

import java.time.Instant;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import ru.yandex.solomon.core.db.model.Service;
import ru.yandex.solomon.core.db.model.ShardSettings;

/**
 * @author Sergey Polovko
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ServiceListItemDto {

    private String id;
    private String name;
    private String monitoringModel;
    private Integer fetchInterval;
    private Integer grid;
    private Integer metricsTtl;
    private Instant createdAt;
    private Instant updatedAt;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMonitoringModel() {
        return monitoringModel;
    }

    public void setMonitoringModel(String monitoringModel) {
        this.monitoringModel = monitoringModel;
    }

    public Integer getFetchInterval() {
        return fetchInterval;
    }

    public void setFetchInterval(Integer fetchInterval) {
        this.fetchInterval = fetchInterval;
    }

    public Integer getGrid() {
        return grid;
    }

    public void setGrid(Integer grid) {
        this.grid = grid;
    }

    public Integer getMetricsTtl() {
        return metricsTtl;
    }

    public void setMetricsTtl(Integer metricsTtl) {
        this.metricsTtl = metricsTtl;
    }

    public Instant getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public Instant getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public static ServiceListItemDto fromModel(@Nonnull Service service) {
        ServiceListItemDto dto = new ServiceListItemDto();
        dto.setId(service.getId());
        dto.setName(service.getName());
        dto.monitoringModel = service.getShardSettings().getType().name();
        dto.fetchInterval = ShardSettings.getInterval(service.getShardSettings(), null);
        dto.grid = ShardSettings.getGrid(service.getShardSettings(), null);
        dto.metricsTtl = ShardSettings.getMetricsTtlDays(service.getShardSettings(), null);
        dto.setCreatedAt(service.getCreatedAt());
        dto.setUpdatedAt(service.getUpdatedAt());
        return dto;
    }
}
