package ru.yandex.solomon.gateway.api.v2.dto;

import java.time.Instant;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import ru.yandex.solomon.core.conf.ShardsManager;
import ru.yandex.solomon.core.db.model.Cluster;
import ru.yandex.solomon.core.db.model.Service;
import ru.yandex.solomon.core.db.model.Shard;
import ru.yandex.solomon.core.db.model.ShardSettings;
import ru.yandex.solomon.core.db.model.ShardState;

/**
 * @author Sergey Polovko
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ShardListItemDto {

    private String id;
    private String projectId;
    private String clusterId;
    private String serviceId;
    private String clusterName;
    private String serviceName;
    private String monitoringModel;
    private Integer fetchInterval;
    private Integer metricsTtl;
    private Instant createdAt;
    private Instant updatedAt;
    private Integer targetErrors;
    private String quotasStatus;
    private ShardState state;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getClusterId() {
        return clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getServiceId() {
        return serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getClusterName() {
        return clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Integer getTargetErrors() {
        return targetErrors;
    }

    public void setTargetErrors(Integer targetErrors) {
        this.targetErrors = targetErrors;
    }

    public String getQuotasStatus() {
        return quotasStatus;
    }

    public void setQuotasStatus(String quotasStatus) {
        this.quotasStatus = quotasStatus;
    }

    public ShardState getState() {
        return state;
    }

    public void setState(ShardState state) {
        this.state = state;
    }

    public String getMonitoringModel() {
        return monitoringModel;
    }

    public void setMonitoringModel(String monitoringModel) {
        this.monitoringModel = monitoringModel;
    }

    public Integer getFetchInterval() {
        return fetchInterval;
    }

    public void setFetchInterval(Integer fetchInterval) {
        this.fetchInterval = fetchInterval;
    }

    public Integer getMetricsTtl() {
        return metricsTtl;
    }

    public void setMetricsTtl(Integer metricsTtl) {
        this.metricsTtl = metricsTtl;
    }

    public Instant getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    public Instant getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Nonnull
    public static ShardListItemDto fromModel(@Nonnull ShardsManager.ShardExtended extended) {
        final Shard shard = extended.shard();
        final Service service = extended.service();
        final Cluster cluster = extended.cluster();
        ShardListItemDto dto = new ShardListItemDto();
        dto.setId(shard.getId());
        dto.setProjectId(shard.getProjectId());
        dto.setClusterId(shard.getClusterId());
        dto.setServiceId(shard.getServiceId());
        dto.setClusterName(shard.getClusterName());
        dto.setServiceName(shard.getServiceName());
        if (!extended.isFull()) {
            return dto;
        }
        dto.setCreatedAt(shard.getCreatedAt());
        dto.setUpdatedAt(shard.getUpdatedAt());
        dto.state = shard.getState();
        dto.metricsTtl = ShardSettings.getMetricsTtlDays(shard.getShardSettings(), null);
        dto.targetErrors = extended.targetErrors();
        dto.quotasStatus = extended.quotas();
        if (cluster != null) {
            if (dto.metricsTtl == null) {
                dto.metricsTtl = ShardSettings.getMetricsTtlDays(cluster.getShardSettings(), null);
            }
        }
        if (service != null) {
            dto.monitoringModel = service.getShardSettings().getType().name();
            dto.fetchInterval = ShardSettings.getInterval(service.getShardSettings(), null);
            if (dto.metricsTtl == null) {
                dto.metricsTtl = ShardSettings.getMetricsTtlDays(service.getShardSettings(), null);
            }
        }
        return dto;
    }
}
