package ru.yandex.solomon.gateway.api.v2.dto.data;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.gateway.api.v2.dto.data.values.HistogramDto;
import ru.yandex.solomon.gateway.api.v2.dto.data.values.LogHistogramDto;
import ru.yandex.solomon.gateway.api.v2.dto.data.values.SummaryDoubleDto;
import ru.yandex.solomon.gateway.api.v2.dto.data.values.SummaryInt64Dto;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class AggrPointDto {

    @JsonProperty
    public long tsMillis;

    @JsonProperty
    public Double valueNum;

    @JsonProperty
    public Long valueDenom;

    @JsonProperty
    public Long longValue;

    @JsonProperty
    public HistogramDto histogram;

    @JsonProperty
    public LogHistogramDto logHistogram;

    @JsonProperty
    public SummaryDoubleDto summaryDouble;

    @JsonProperty
    public SummaryInt64Dto summaryInt64;

    @JsonProperty
    public Long count;

    @JsonProperty
    public Boolean merge;

    @JsonProperty
    public Long stepMillis;

    @Nonnull
    public static AggrPointDto fromModel(@Nonnull AggrPoint aggrPoint) {
        AggrPointDto dto = new AggrPointDto();

        dto.tsMillis = aggrPoint.tsMillis;
        dto.valueNum = aggrPoint.valueNum;
        dto.valueDenom = aggrPoint.valueDenom;
        dto.count = aggrPoint.count;
        dto.merge = aggrPoint.merge;
        dto.stepMillis = aggrPoint.stepMillis;
        dto.longValue = aggrPoint.longValue;
        dto.histogram = Nullables.map(aggrPoint.histogram, HistogramDto::fromModel);
        dto.summaryDouble = Nullables.map(aggrPoint.summaryDouble, SummaryDoubleDto::fromModel);
        dto.summaryInt64 = Nullables.map(aggrPoint.summaryInt64, SummaryInt64Dto::fromModel);
        dto.logHistogram = Nullables.map(aggrPoint.logHistogram, LogHistogramDto::fromModel);

        return dto;
    }
}
