package ru.yandex.solomon.gateway.api.v2.dto.data;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.gateway.data.ExtendedStockpileKey;
import ru.yandex.solomon.model.StockpileKey;
import ru.yandex.stockpile.client.shard.StockpileLocalId;
import ru.yandex.stockpile.client.shard.StockpileShardId;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class StockpileKeyDto {

    @JsonProperty
    public String destination;

    @JsonProperty
    public String dc;

    @JsonProperty
    public String shardId;

    @JsonProperty
    public String localId;

    @JsonProperty
    public String host;

    public static StockpileKeyDto fromModel(ExtendedStockpileKey model) {
        StockpileKeyDto dto = new StockpileKeyDto();

        StockpileKey key = model.getKey();

        dto.destination = key.getDestination();
        dto.shardId = StockpileShardId.toString(key.getShardId());
        dto.localId = StockpileLocalId.toString(key.getLocalId());
        dto.host = model.getHost();

        return dto;
    }
}
