package ru.yandex.solomon.gateway.api.v2.dto.data.values;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.solomon.model.type.Histogram;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class HistogramDto {

    @JsonProperty
    public double[] bounds;

    @JsonProperty
    public long[] buckets;

    @JsonProperty
    public long inf;

    public static HistogramDto fromModel(Histogram model) {
        HistogramDto dto = new HistogramDto();

        long inf = 0;

        final double[] bounds;
        final long[] buckets;

        int count = model.count();

        if (count > 0) {
            final int countWithoutInf;

            double lastBound = model.upperBound(count - 1);

            if (Double.compare(lastBound, Histograms.INF_BOUND) == 0) {
                inf = model.value(count - 1);
                countWithoutInf = count - 1;
            } else {
                inf = 0;
                countWithoutInf = count;
            }

            bounds = new double[countWithoutInf];
            buckets = new long[countWithoutInf];

            for (int i = 0; i < countWithoutInf; ++i) {
                double bound = model.upperBound(i);
                long bucket = model.value(i);

                bounds[i] = bound;
                buckets[i] = bucket;
            }
        } else {
            bounds = new double[0];
            buckets = new long[0];
        }

        dto.bounds = bounds;
        dto.buckets = buckets;
        dto.inf = inf;

        return dto;
    }
}
