package ru.yandex.solomon.gateway.api.v2.dto.data.values;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class LogHistogramDto {

    @JsonProperty
    public double[] buckets;

    @JsonProperty
    public long countZero;

    @JsonProperty
    public int startPower;

    @JsonProperty
    public int maxBucketsSize;

    @JsonProperty
    public double base;

    public static LogHistogramDto fromModel(LogHistogram model) {
        LogHistogramDto dto = new LogHistogramDto();

        int count = model.countBucket();

        double[] buckets = new double[count];
        for (int i = 0; i < count; ++i) {
            buckets[i] = model.getBucketValue(i);
        }

        dto.buckets = buckets;
        dto.countZero = model.getCountZero();
        dto.startPower = model.getStartPower();
        dto.maxBucketsSize = model.getMaxBucketsSize();
        dto.base = model.getBase();

        return dto;
    }
}
