package ru.yandex.solomon.gateway.api.v2.dto.data.values;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class LogHistogramValuesDto implements ValuesDto {

    private final ShortLogHistogramDto[] values;

    @JsonCreator
    public LogHistogramValuesDto(ShortLogHistogramDto[] values) {
        this.values = values;
    }

    @JsonValue
    public ShortLogHistogramDto[] getValues() {
        return values;
    }
}
