package ru.yandex.solomon.gateway.api.v2.dto.data.values;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.model.timeseries.aggregation.DoubleSummary;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OldStatsDto {
    @JsonProperty
    public double max;

    @JsonProperty
    public double min;

    @JsonProperty
    public double sum;

    @JsonProperty
    public double last;

    @JsonProperty
    public double avg;

    @Nonnull
    public static OldStatsDto fromModel(@Nonnull DoubleSummary model) {
        OldStatsDto dto = new OldStatsDto();
        dto.max = model.getMax();
        dto.min = model.getMin();
        dto.sum = model.getSum();
        dto.last = model.getLast();
        dto.avg = model.getAvg();
        return dto;
    }
}
