package ru.yandex.solomon.gateway.api.v2.dto.data.values;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.monlib.metrics.summary.SummaryDoubleSnapshot;
import ru.yandex.solomon.model.timeseries.aggregation.DoubleSummary;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SummaryDoubleDto {

    @JsonProperty
    public long count;

    @JsonProperty
    public double max;

    @JsonProperty
    public double min;

    @JsonProperty
    public double sum;

    @JsonProperty
    public double last;

    @Nonnull
    public static SummaryDoubleDto fromModel(@Nonnull SummaryDoubleSnapshot model) {
        SummaryDoubleDto dto = new SummaryDoubleDto();

        dto.count = model.getCount();
        dto.max = model.getMax();
        dto.min = model.getMin();
        dto.sum = model.getSum();
        dto.last = model.getLast();

        return dto;
    }

    @Nonnull
    public static SummaryDoubleDto fromModel(@Nonnull DoubleSummary model) {
        SummaryDoubleDto dto = new SummaryDoubleDto();

        dto.count = model.getCount();
        dto.max = model.getMax();
        dto.min = model.getMin();
        dto.sum = model.getSum();
        dto.last = model.getLast();

        return dto;
    }
}
