package ru.yandex.solomon.gateway.api.v2.dto.data.values;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SummaryDoubleValuesDto implements ValuesDto {

    private final SummaryDoubleDto[] values;

    @JsonCreator
    public SummaryDoubleValuesDto(SummaryDoubleDto[] values) {
        this.values = values;
    }

    @JsonValue
    public SummaryDoubleDto[] getValues() {
        return values;
    }

}
