package ru.yandex.solomon.gateway.api.v2.dto.data.values;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SummaryInt64Dto {

    @JsonProperty
    public long count;

    @JsonProperty
    public long max;

    @JsonProperty
    public long min;

    @JsonProperty
    public long sum;

    @JsonProperty
    public long last;

    public static SummaryInt64Dto fromModel(SummaryInt64Snapshot model) {
        SummaryInt64Dto dto = new SummaryInt64Dto();

        dto.count = model.getCount();
        dto.max = model.getMax();
        dto.min = model.getMin();
        dto.sum = model.getSum();
        dto.last = model.getLast();

        return dto;
    }
}
