package ru.yandex.solomon.gateway.api.v2.managers;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;
import ru.yandex.solomon.labels.protobuf.LabelValidationFilterConverter;
import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.metabase.protobuf.LabelValidationFilter;
import ru.yandex.solomon.metrics.client.LabelValuesResponse;
import ru.yandex.solomon.util.labelStats.LabelStats;
import ru.yandex.solomon.util.labelStats.LabelValuesStats;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ShardLabelsManager {

    private final SolomonConfHolder solomonConfHolder;

    @Autowired
    public ShardLabelsManager(SolomonConfHolder solomonConfHolder) {
        this.solomonConfHolder = solomonConfHolder;
    }

    public LabelValuesResponse findShardLabelValues(
        List<String> names,
        Selectors selectors,
        String text,
        LabelValidationFilter validationFilter,
        int limit)
    {
        List<Labels> shardLabels = solomonConfHolder.getConfOrThrow().getCorrectShards().stream()
            .map(shard -> shard.getShardKeyAndId().getShardKey().toLabels())
            .filter(selectors::match)
            .collect(Collectors.toList());

        int metricCount = shardLabels.size();

        Map<String, LabelStats> statsByKey = new HashMap<>(3);

        shardLabels.forEach(labels -> labels.forEach(label -> {
            if (names.isEmpty() || names.contains(label.getKey())) {
                LabelStats s = statsByKey.computeIfAbsent(label.getKey(), k -> LabelStats.create());
                s.add(label.getValue());
            }
        }));

        LabelValuesStats labelValuesStats = new LabelValuesStats(statsByKey, metricCount);

        labelValuesStats.filter(text);
        labelValuesStats.filter(LabelValidationFilterConverter.protoToFilter(validationFilter));
        labelValuesStats.limit(limit);

        return new LabelValuesResponse(labelValuesStats, Collections.emptyMap());
    }
}
