package ru.yandex.solomon.gateway.api.v3;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.idm.IdmClient;
import ru.yandex.solomon.acl.db.ProjectAclEntryDao;
import ru.yandex.solomon.auth.Authorizer;
import ru.yandex.solomon.config.protobuf.TIdmConfig;
import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;
import ru.yandex.solomon.core.db.dao.ProjectsDao;
import ru.yandex.solomon.gateway.api.v3.intranet.ProjectRoleService;
import ru.yandex.solomon.gateway.api.v3.intranet.impl.ProjectRoleServiceImpl;
import ru.yandex.staff.StaffClient;

/**
 * @author Alexey Trushkin
 */
@Configuration
@ParametersAreNonnullByDefault
public class ApiV3Context {

    @Bean
    public ProjectRoleService projectRoleService(
            Optional<ProjectAclEntryDao> projectAclEntryDao,
            Optional<TIdmConfig> idmConfig,
            Optional<IdmClient> idmClient,
            Optional<StaffClient> staffClient,
            Authorizer authorizer,
            SolomonConfHolder confHolder,
            ProjectsDao projectsDao)
    {
        if (projectAclEntryDao.isEmpty() || idmClient.isEmpty() || idmConfig.isEmpty() || staffClient.isEmpty()) {
            return null;
        }
        return new ProjectRoleServiceImpl(
                projectAclEntryDao.get(),
                idmClient.get(),
                idmConfig.get(),
                staffClient.get(),
                authorizer,
                confHolder,
                projectsDao);
    }
}
