package ru.yandex.solomon.gateway.api.v3.cloud;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.solomon.auth.AuthContext;
import ru.yandex.solomon.auth.internal.InternalAuthorizer;
import ru.yandex.solomon.config.gateway.TGatewayCloudConfig;
import ru.yandex.solomon.core.db.dao.ConfigDaoContext;
import ru.yandex.solomon.core.db.dao.ServiceProvidersDao;
import ru.yandex.solomon.gateway.api.v3.cloud.priv.ServiceProviderService;
import ru.yandex.solomon.gateway.api.v3.cloud.priv.impl.ServiceProviderServiceImpl;
import ru.yandex.solomon.gateway.api.v3.cloud.priv.impl.ServiceProviderServiceStub;

/**
 * @author Oleg Baryshnikov
 */
@Import({
        AuthContext.class,
        ConfigDaoContext.class,
})
@Configuration
@ParametersAreNonnullByDefault
public class CloudApiV3Context {
    @Bean
    public ServiceProviderService serviceProviderServiceV3(
            Optional<TGatewayCloudConfig> config,
            InternalAuthorizer authorizer,
            ServiceProvidersDao serviceProvidersDao)
    {
        if (config.isPresent()) {
            String entityIdPrefix = config.get().getEntityIdPrefix();
            return new ServiceProviderServiceImpl(authorizer, serviceProvidersDao, entityIdPrefix);
        }
        return new ServiceProviderServiceStub();
    }
}
