package ru.yandex.solomon.gateway.api.v3.cloud.priv;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.tuple.Pair;
import yandex.cloud.priv.monitoring.v3.ServiceProviderOuterClass.ServiceProvider;
import yandex.cloud.priv.monitoring.v3.ServiceProviderServiceOuterClass.CreateServiceProviderRequest;
import yandex.cloud.priv.monitoring.v3.ServiceProviderServiceOuterClass.DeleteServiceProviderRequest;
import yandex.cloud.priv.monitoring.v3.ServiceProviderServiceOuterClass.GetServiceProviderRequest;
import yandex.cloud.priv.monitoring.v3.ServiceProviderServiceOuterClass.ListServiceProvidersRequest;
import yandex.cloud.priv.monitoring.v3.ServiceProviderServiceOuterClass.ListServiceProvidersResponse;
import yandex.cloud.priv.monitoring.v3.ServiceProviderServiceOuterClass.UpdateServiceProviderRequest;
import yandex.cloud.priv.operation.PO.Operation;

import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface ServiceProviderService {
    CompletableFuture<Pair<ServiceProvider, Integer>> get(GetServiceProviderRequest request, AuthSubject subject);

    CompletableFuture<ListServiceProvidersResponse> list(ListServiceProvidersRequest request, AuthSubject subject);

    CompletableFuture<Operation> create(CreateServiceProviderRequest request, AuthSubject subject);

    CompletableFuture<Operation> update(UpdateServiceProviderRequest request, AuthSubject subject, int etag);

    CompletableFuture<Operation> delete(DeleteServiceProviderRequest request, AuthSubject subject);
}
