package ru.yandex.solomon.gateway.api.v3.cloud.priv.dto;

import java.util.concurrent.Callable;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.cloud.priv.monitoring.v3.AlertTemplate;
import ru.yandex.cloud.priv.monitoring.v3.CreateAlertTemplateRequest;
import ru.yandex.cloud.priv.monitoring.v3.DeployAlertTemplateRequest;
import ru.yandex.cloud.priv.monitoring.v3.ListAlertTemplateRequest;
import ru.yandex.cloud.priv.monitoring.v3.ListAlertTemplateResponse;
import ru.yandex.cloud.priv.monitoring.v3.ListAlertTemplateVersionsRequest;
import ru.yandex.cloud.priv.monitoring.v3.ListAlertTemplateVersionsResponse;
import ru.yandex.cloud.priv.monitoring.v3.PublishAlertTemplateRequest;
import ru.yandex.cloud.priv.monitoring.v3.ReadAlertTemplateRequest;
import ru.yandex.cloud.priv.monitoring.v3.UnpublishAlertTemplateRequest;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class CloudAlertTemplateDtoConverter {

    public AlertTemplate convertToCloud(ru.yandex.monitoring.api.v3.AlertTemplate alertTemplate) {
        return safe(() -> AlertTemplate.parseFrom(alertTemplate.toByteArray()));
    }

    public ListAlertTemplateVersionsResponse convertToCloud(ru.yandex.monitoring.api.v3.ListAlertTemplateVersionsResponse response) {
        return safe(() -> ListAlertTemplateVersionsResponse.parseFrom(response.toByteArray()));
    }

    public ListAlertTemplateResponse convertToCloud(ru.yandex.monitoring.api.v3.ListAlertTemplateResponse response) {
        return safe(() -> ListAlertTemplateResponse.parseFrom(response.toByteArray()));
    }

    public ru.yandex.monitoring.api.v3.CreateAlertTemplateRequest convertToInternal(CreateAlertTemplateRequest request) {
        return safe(() -> ru.yandex.monitoring.api.v3.CreateAlertTemplateRequest.parseFrom(request.toByteArray()));
    }

    public ru.yandex.monitoring.api.v3.ReadAlertTemplateRequest convertToInternal(ReadAlertTemplateRequest request) {
        return safe(() -> ru.yandex.monitoring.api.v3.ReadAlertTemplateRequest.parseFrom(request.toByteArray()));
    }

    public ru.yandex.monitoring.api.v3.PublishAlertTemplateRequest convertToInternal(PublishAlertTemplateRequest request) {
        return safe(() -> ru.yandex.monitoring.api.v3.PublishAlertTemplateRequest.parseFrom(request.toByteArray()));
    }

    public ru.yandex.monitoring.api.v3.UnpublishAlertTemplateRequest convertToInternal(UnpublishAlertTemplateRequest request) {
        return safe(() -> ru.yandex.monitoring.api.v3.UnpublishAlertTemplateRequest.parseFrom(request.toByteArray()));
    }

    public ru.yandex.monitoring.api.v3.DeployAlertTemplateRequest convertToInternal(DeployAlertTemplateRequest request) {
        return safe(() -> ru.yandex.monitoring.api.v3.DeployAlertTemplateRequest.parseFrom(request.toByteArray()));
    }

    public ru.yandex.monitoring.api.v3.ListAlertTemplateVersionsRequest convertToInternal(ListAlertTemplateVersionsRequest request) {
        return safe(() -> ru.yandex.monitoring.api.v3.ListAlertTemplateVersionsRequest.parseFrom(request.toByteArray()));
    }

    public ru.yandex.monitoring.api.v3.ListAlertTemplateRequest convertToInternal(ListAlertTemplateRequest request) {
        return safe(() -> ru.yandex.monitoring.api.v3.ListAlertTemplateRequest.parseFrom(request.toByteArray()));
    }

    private <T> T safe(Callable<T> supplier) {
        try {
            return supplier.call();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
