package ru.yandex.solomon.gateway.api.v3.cloud.priv.dto;

import java.util.concurrent.Callable;

import yandex.cloud.priv.monitoring.v3.DashboardOuterClass;
import yandex.cloud.priv.monitoring.v3.DashboardServiceOuterClass;

import ru.yandex.monitoring.api.v3.CreateDashboardRequest;
import ru.yandex.monitoring.api.v3.Dashboard;
import ru.yandex.monitoring.api.v3.DeleteDashboardRequest;
import ru.yandex.monitoring.api.v3.GetDashboardRequest;
import ru.yandex.monitoring.api.v3.ListDashboardsRequest;
import ru.yandex.monitoring.api.v3.ListDashboardsResponse;
import ru.yandex.monitoring.api.v3.UpdateDashboardRequest;

/**
 * @author Alexey Trushkin
 */
public class CloudDashboardDtoConverter {

    public GetDashboardRequest convertToIntranet(DashboardServiceOuterClass.GetDashboardRequest request) {
        return safe(() -> GetDashboardRequest.parseFrom(request.toByteArray()));
    }

    public DashboardServiceOuterClass.GetDashboardRequest convertFromIntranet(GetDashboardRequest request) {
        return safe(() -> DashboardServiceOuterClass.GetDashboardRequest.parseFrom(request.toByteArray()));
    }

    public DashboardOuterClass.Dashboard convertFromIntranet(Dashboard request) {
        return safe(() -> DashboardOuterClass.Dashboard.parseFrom(request.toByteArray()));
    }

    public Dashboard convertToIntranet(DashboardOuterClass.Dashboard request) {
        return safe(() -> Dashboard.parseFrom(request.toByteArray()));
    }

    public ListDashboardsRequest convertToIntranet(DashboardServiceOuterClass.ListDashboardsRequest request) {
        return safe(() -> ListDashboardsRequest.parseFrom(request.toByteArray()));
    }

    public DashboardServiceOuterClass.ListDashboardsRequest convertFromIntranet(ListDashboardsRequest request) {
        return safe(() -> DashboardServiceOuterClass.ListDashboardsRequest.parseFrom(request.toByteArray()));
    }

    public DashboardServiceOuterClass.ListDashboardsResponse convertFromIntranet(ListDashboardsResponse request) {
        return safe(() -> DashboardServiceOuterClass.ListDashboardsResponse.parseFrom(request.toByteArray()));
    }

    public ListDashboardsResponse convertToIntranet(DashboardServiceOuterClass.ListDashboardsResponse request) {
        return safe(() -> ListDashboardsResponse.parseFrom(request.toByteArray()));
    }

    public CreateDashboardRequest convertToIntranet(DashboardServiceOuterClass.CreateDashboardRequest request) {
        return safe(() -> CreateDashboardRequest.parseFrom(request.toByteArray()));
    }

    public DashboardServiceOuterClass.CreateDashboardRequest convertFromIntranet(CreateDashboardRequest request) {
        return safe(() -> DashboardServiceOuterClass.CreateDashboardRequest.parseFrom(request.toByteArray()));
    }

    public UpdateDashboardRequest convertToIntranet(DashboardServiceOuterClass.UpdateDashboardRequest request) {
        return safe(() -> UpdateDashboardRequest.parseFrom(request.toByteArray()));
    }

    public DashboardServiceOuterClass.UpdateDashboardRequest convertFromIntranet(UpdateDashboardRequest request) {
        return safe(() -> DashboardServiceOuterClass.UpdateDashboardRequest.parseFrom(request.toByteArray()));
    }

    public DeleteDashboardRequest convertToIntranet(DashboardServiceOuterClass.DeleteDashboardRequest request) {
        return safe(() -> DeleteDashboardRequest.parseFrom(request.toByteArray()));
    }

    public DashboardServiceOuterClass.DeleteDashboardRequest convertFromIntranet(DeleteDashboardRequest request) {
        return safe(() -> DashboardServiceOuterClass.DeleteDashboardRequest.parseFrom(request.toByteArray()));
    }

    private <T> T safe(Callable<T> supplier) {
        try {
            return supplier.call();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
