package ru.yandex.solomon.gateway.api.v3.cloud.priv.dto;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Message;
import yandex.cloud.priv.operation.PO;

import ru.yandex.monitoring.api.v3.Operation;
import ru.yandex.solomon.operation.OperationDtoConverter;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class CloudOperationDtoConverter {

    private final OperationDtoConverter operationDtoConverter;

    public CloudOperationDtoConverter() {
        operationDtoConverter = new OperationDtoConverter();
    }

    public PO.Operation wrapCloud(Void unused, @Nullable Throwable throwable) {
        var op = operationDtoConverter.wrap(unused, throwable);
        return getOperation(op);
    }

    public PO.Operation wrapCloud(Throwable throwable) {
        var op = operationDtoConverter.wrap(throwable);
        return getOperation(op);
    }

    public PO.Operation wrapCloud(Message message, @Nullable Throwable throwable) {
        var op = operationDtoConverter.wrap(message, throwable);
        return getOperation(op);
    }

    public PO.Operation wrapCloud(Message message) {
        var op = operationDtoConverter.wrap(message);
        return getOperation(op);
    }

    public PO.Operation wrapCloud(String operationId, @Nullable Throwable throwable) {
        var op = operationDtoConverter.wrap(operationId, throwable);
        return getOperation(op);
    }

    private PO.Operation getOperation(Operation op) {
        try {
            return PO.Operation.parseFrom(op.toByteArray());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
