package ru.yandex.solomon.gateway.api.v3.cloud.priv.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import yandex.cloud.priv.monitoring.v3.ServiceProviderOuterClass;
import yandex.cloud.priv.monitoring.v3.ServiceProviderServiceGrpc;
import yandex.cloud.priv.monitoring.v3.ServiceProviderServiceOuterClass;
import yandex.cloud.priv.operation.PO;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.solomon.gateway.api.v3.cloud.priv.ServiceProviderService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ParametersAreNonnullByDefault
public class GrpcServiceProviderServiceV3Alpha extends ServiceProviderServiceGrpc.ServiceProviderServiceImplBase implements GrpcService {
    private final ServiceProviderService service;

    @Autowired
    public GrpcServiceProviderServiceV3Alpha(ServiceProviderService service) {
        this.service = service;
    }

    @Override
    public void get(ServiceProviderServiceOuterClass.GetServiceProviderRequest request, StreamObserver<ServiceProviderOuterClass.ServiceProvider> responseObserver) {
        GrpcMethodHandler.handleGet(service::get, request, responseObserver);
    }

    @Override
    public void list(ServiceProviderServiceOuterClass.ListServiceProvidersRequest request,
                     StreamObserver<ServiceProviderServiceOuterClass.ListServiceProvidersResponse> responseObserver) {
        GrpcMethodHandler.handle(service::list, request, responseObserver);
    }

    @Override
    public void create(ServiceProviderServiceOuterClass.CreateServiceProviderRequest request,
                       StreamObserver<PO.Operation> responseObserver) {
        GrpcMethodHandler.handle(service::create, request, responseObserver);
    }

    @Override
    public void update(ServiceProviderServiceOuterClass.UpdateServiceProviderRequest request,
                       StreamObserver<PO.Operation> responseObserver) {
        GrpcMethodHandler.handleUpdate(service::update, request, responseObserver);
    }

    @Override
    public void delete(ServiceProviderServiceOuterClass.DeleteServiceProviderRequest request, StreamObserver<PO.Operation> responseObserver) {
        GrpcMethodHandler.handle(service::delete, request, responseObserver);
    }
}
