package ru.yandex.solomon.gateway.api.v3.cloud.priv.grpc;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import yandex.cloud.priv.monitoring.v3.DashboardOuterClass;
import yandex.cloud.priv.monitoring.v3.DashboardServiceGrpc;
import yandex.cloud.priv.monitoring.v3.DashboardServiceOuterClass;
import yandex.cloud.priv.operation.PO;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.misc.concurrent.CompletableFutures;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.gateway.api.v3.cloud.priv.dto.CloudDashboardDtoConverter;
import ru.yandex.solomon.gateway.api.v3.cloud.priv.dto.CloudOperationDtoConverter;
import ru.yandex.solomon.gateway.api.v3.intranet.DashboardService;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Alexey Trushkin
 */
@Component
@ParametersAreNonnullByDefault
public class PrivateGrpcCloudDashboardService extends DashboardServiceGrpc.DashboardServiceImplBase implements GrpcService {
    private final DashboardService service;
    private final CloudDashboardDtoConverter converter;
    private final CloudOperationDtoConverter operationConverter;

    @Autowired
    public PrivateGrpcCloudDashboardService(DashboardService service) {
        this.service = service;
        converter = new CloudDashboardDtoConverter();
        operationConverter = new CloudOperationDtoConverter();
    }

    @Override
    public void get(
            DashboardServiceOuterClass.GetDashboardRequest request,
            StreamObserver<DashboardOuterClass.Dashboard> responseObserver)
    {
        GrpcMethodHandler.handle(this::doGet, request, responseObserver);
    }

    private CompletableFuture<DashboardOuterClass.Dashboard> doGet(
            DashboardServiceOuterClass.GetDashboardRequest request,
            AuthSubject subject)
    {
        return CompletableFutures.safeCall(() -> service.get(converter.convertToIntranet(request), subject))
                .thenApply(converter::convertFromIntranet);
    }

    @Override
    public void list(DashboardServiceOuterClass.ListDashboardsRequest request,
                     StreamObserver<DashboardServiceOuterClass.ListDashboardsResponse> responseObserver)
    {
        GrpcMethodHandler.handle(this::doList, request, responseObserver);
    }

    private CompletableFuture<DashboardServiceOuterClass.ListDashboardsResponse> doList(
            DashboardServiceOuterClass.ListDashboardsRequest request,
            AuthSubject subject)
    {
        return CompletableFutures.safeCall(() -> service.list(converter.convertToIntranet(request), subject))
                .thenApply(converter::convertFromIntranet);
    }

    @Override
    public void create(DashboardServiceOuterClass.CreateDashboardRequest request,
                       StreamObserver<PO.Operation> responseObserver)
    {
        GrpcMethodHandler.handle(this::doCreate, request, responseObserver, operationConverter::wrapCloud);
    }

    private CompletableFuture<DashboardOuterClass.Dashboard> doCreate(
            DashboardServiceOuterClass.CreateDashboardRequest request,
            AuthSubject subject)
    {
        return CompletableFutures.safeCall(() -> service.create(converter.convertToIntranet(request), subject))
                .thenApply(converter::convertFromIntranet);
    }

    @Override
    public void update(DashboardServiceOuterClass.UpdateDashboardRequest request,
                       StreamObserver<PO.Operation> responseObserver)
    {
        GrpcMethodHandler.handle(this::doUpdate, request, responseObserver, operationConverter::wrapCloud);
    }

    private CompletableFuture<DashboardOuterClass.Dashboard> doUpdate(
            DashboardServiceOuterClass.UpdateDashboardRequest request,
            AuthSubject subject)
    {
        return CompletableFutures.safeCall(() -> service.update(converter.convertToIntranet(request), subject))
                .thenApply(converter::convertFromIntranet);
    }

    @Override
    public void delete(DashboardServiceOuterClass.DeleteDashboardRequest request,
                       StreamObserver<PO.Operation> responseObserver)
    {
        GrpcMethodHandler.handle(this::doDelete, request, responseObserver, operationConverter::wrapCloud);
    }

    private CompletableFuture<Empty> doDelete(
            DashboardServiceOuterClass.DeleteDashboardRequest request,
            AuthSubject subject)
    {
        return CompletableFutures.safeCall(() -> service.delete(converter.convertToIntranet(request), subject));
    }

    @Override
    public void listOperations(DashboardServiceOuterClass.ListDashboardOperationsRequest request,
                               StreamObserver<DashboardServiceOuterClass.ListDashboardOperationsResponse> responseObserver)
    {
        GrpcMethodHandler.SimpleHandlerFunc<DashboardServiceOuterClass.ListDashboardOperationsRequest, DashboardServiceOuterClass.ListDashboardOperationsResponse> returnEmpty =
                (request1, subject) -> DashboardServiceOuterClass.ListDashboardOperationsResponse.getDefaultInstance();
        GrpcMethodHandler.handle(returnEmpty, request, responseObserver);
    }
}
