package ru.yandex.solomon.gateway.api.v3.cloud.priv.grpc;

import javax.annotation.ParametersAreNonnullByDefault;

import io.grpc.stub.StreamObserver;
import org.springframework.stereotype.Component;
import yandex.cloud.priv.monitoring.v3.OperationServiceGrpc;
import yandex.cloud.priv.monitoring.v3.OperationServiceOuterClass;
import yandex.cloud.priv.operation.PO;

import ru.yandex.grpc.utils.GrpcService;
import ru.yandex.solomon.gateway.api.v3.cloud.priv.dto.CloudOperationDtoConverter;
import ru.yandex.solomon.grpc.handler.GrpcMethodHandler;

/**
 * @author Alexey Trushkin
 */
@Component
@ParametersAreNonnullByDefault
public class PrivateGrpcCloudOperationService extends OperationServiceGrpc.OperationServiceImplBase implements GrpcService {

    private final CloudOperationDtoConverter operationConverter;

    public PrivateGrpcCloudOperationService() {
        operationConverter = new CloudOperationDtoConverter();
    }

    @Override
    public void get(OperationServiceOuterClass.GetOperationRequest request, StreamObserver<PO.Operation> responseObserver) {
        GrpcMethodHandler.SimpleHandlerFunc<OperationServiceOuterClass.GetOperationRequest, PO.Operation> returnEmpty =
                (request1, subject) -> operationConverter.wrapCloud(request.getOperationId(), null);
        GrpcMethodHandler.handle(returnEmpty, request, responseObserver);
    }
}
